<?php
// delete_file.php
include "db.php";
session_start();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Method not allowed');
}

$token = $_POST['token'] ?? '';
$folder_id = (isset($_POST['folder_id']) && $_POST['folder_id'] !== '') ? intval($_POST['folder_id']) : null;

if ($token === '') {
    $_SESSION['upload_flash'] = ['status' => 'error', 'msg' => 'Invalid request'];
    $loc = 'drive.php' . ($folder_id !== null ? '?folder=' . $folder_id : '');
    header('Location: ' . $loc);
    exit;
}

// Find the file by token
$stmt = $conn->prepare("SELECT id, stored_name, original_name FROM files WHERE token = ?");
$stmt->bind_param("s", $token);
$stmt->execute();
$file = $stmt->get_result()->fetch_assoc();

if (!$file) {
    $_SESSION['upload_flash'] = ['status' => 'error', 'msg' => 'File not found'];
    $loc = 'drive.php' . ($folder_id !== null ? '?folder=' . $folder_id : '');
    header('Location: ' . $loc);
    exit;
}

// Delete physical file if exists
$path = __DIR__ . '/uploads/' . $file['stored_name'];
if (is_file($path)) {
    @unlink($path);
}

// Delete DB record
$dstmt = $conn->prepare("DELETE FROM files WHERE id = ?");
$dstmt->bind_param("i", $file['id']);
$ok = $dstmt->execute();

if ($ok) {
    $_SESSION['upload_flash'] = ['status' => 'success', 'msg' => 'File deleted: ' . $file['original_name']];
} else {
    $_SESSION['upload_flash'] = ['status' => 'error', 'msg' => 'Failed to delete file record'];
}

// Redirect back to folder
$loc = 'drive.php' . ($folder_id !== null ? '?folder=' . $folder_id : '');
header('Location: ' . $loc);
exit;
