<?php
include "db.php";

if (!isset($_GET["token"])) die("Invalid request.");

$token = $_GET["token"];
$stmt = $conn->prepare("SELECT * FROM files WHERE token = ?");
$stmt->bind_param("s", $token);
$stmt->execute();
$file = $stmt->get_result()->fetch_assoc();

$filePath = "uploads/" . $file["stored_name"];
$ext = strtolower(pathinfo($file["original_name"], PATHINFO_EXTENSION));
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Preview <?= htmlspecialchars($file["original_name"]) ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container py-5">

<h3>Preview: <?= htmlspecialchars($file["original_name"]) ?></h3>

<?php if (in_array($ext, ["jpg", "jpeg", "png", "gif"])): ?>
  <img src="<?= $filePath ?>" class="img-fluid" alt="Preview">
<?php elseif ($ext === "pdf"): ?>
  <embed src="<?= $filePath ?>" type="application/pdf" width="100%" height="600px">
<?php elseif (in_array($ext, ["txt", "csv"])): ?>
  <pre><?php echo htmlspecialchars(file_get_contents($filePath)); ?></pre>
<?php else: ?>
  <p>Cannot preview this file type. <a href="download.php?token=<?= $file['token'] ?>">Download instead</a></p>
<?php endif; ?>

</body>
</html>
